﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using Newtonsoft.Json.Linq;
using Wizdom365.BLL.IoC;
using Wizdom365.BLL.Managers;
using Wizdom365.BLL.Managers.Contracts;

namespace GUI.Web.Base.Bundles
{
    public partial class Configuration : Page
    {
        private readonly WebResourceManager _webResourceManager;
        public Configuration()
            : this(Ioc.Resolve<WebResourceManager>())
        {
        }

        public Configuration(WebResourceManager webResourceManager)
        {
            _webResourceManager = webResourceManager;
        }

        protected override void OnLoad(EventArgs e)
        {
            Response.Cache.SetCacheability(HttpCacheability.NoCache);
            Response.ContentType = "text/javascript";

            var res = _webResourceManager.GetConfiguration(false); // bsc > never ever should we includeAttributes thru this page, as its anonymous
            Response.Write(res);
            Response.Flush();
            Response.SuppressContent = true;
            HttpContext.Current.ApplicationInstance.CompleteRequest();
            //Response.End();
        }

        protected void Page_Init(object sender, EventArgs e)
        {
            Page.ClientTarget = "uplevel"; // fix js, for IE 11
        }
    }
}